/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.pathfinding;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalInterruptedException;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.RequestPathfindingGoal;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class GoToLocationGoal
extends Goal {
    private final Vector2 destination;
    private final MessageDispatcher messageDispatcher;
    private final TiledMap map;

    public GoToLocationGoal(Entity parentEntity, Vector2 destination, MessageDispatcher messageDispatcher, TiledMap map) {
        super(parentEntity);
        this.destination = destination;
        this.messageDispatcher = messageDispatcher;
        this.map = map;
        this.addRequestPathfindingGoal();
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        Goal currentChildGoal = (Goal)this.childGoals.peek();
        if (currentChildGoal != null) {
            try {
                currentChildGoal.update(deltaTimeSeconds);
            }
            catch (GoalInterruptedException e) {
                this.childGoals.clear();
                this.addRequestPathfindingGoal();
            }
            if (currentChildGoal.isComplete()) {
                this.childGoals.pop();
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.childGoals.isEmpty();
    }

    private void addRequestPathfindingGoal() {
        this.childGoals.addLast(new RequestPathfindingGoal(this.parentEntity, this, this.destination, this.messageDispatcher, this.map));
    }
}

